﻿#if FINAL_IK
using UnityEngine;
using System.Collections.Generic;

using RootMotion.FinalIK;


namespace NuitrackSDK.Tutorials.FinalIK
{
    [AddComponentMenu("NuitrackSDK/Tutorials/Final IK/Tentacles Nuitrack Controller")]
    public class TentaclesNuitrackController : MonoBehaviour
    {
        [SerializeField] FABRIK fABRIK;
        [SerializeField] List<nuitrack.JointType> handJoints;
        [SerializeField] float interpolationRatio = 4f;

        float HandLength(UserData.SkeletonData skeleton)
        {
            float handLength = 0;

            for (int i = 0; i < handJoints.Count - 1; i++)
                handLength += (skeleton.GetJoint(handJoints[i]).Position - skeleton.GetJoint(handJoints[i + 1]).Position).magnitude;

            return handLength;
        }

        float TentaclesLength
        {
            get
            {
                IKSolver.Bone[] bones = fABRIK.solver.bones;

                float length = 0;

                for (int i = 0; i < bones.Length - 1; i++)
                    length += (bones[i].transform.position - bones[i + 1].transform.position).magnitude;

                return length;
            }
        }

        void Update()
        {
            if (NuitrackManager.Users.Current == null || NuitrackManager.Users.Current.Skeleton == null)
                return;

            UserData.SkeletonData skeleton = NuitrackManager.Users.Current.Skeleton;

            Vector3 localHandPosition = (skeleton.GetJoint(handJoints[handJoints.Count - 1]).Position - skeleton.GetJoint(handJoints[0]).Position) / HandLength(skeleton);
            fABRIK.solver.target.localPosition = Vector3.Lerp(fABRIK.solver.target.localPosition, localHandPosition * TentaclesLength, Time.deltaTime * interpolationRatio);
        }
    }
}
#endif